package planetarijum;

import java.awt.Color;
import java.awt.Graphics;

public class Zemlja extends Objekat {

	// svaka planeta ima svoje koordinate, precnik, i referencu na samu sebe
	// referenca je potrebna u slucaju dodavanja satelita ili prstenova
	public Zemlja(int x, int y, int r, int rast, Objekat[] obj) {
		super(x, y, r, rast, obj);
	}

	@Override
	public void draw(Graphics g) {
		// kreiranje boje, RGB format
		int R = 0;
		int G = 128;
		int B = 192;
		Color zemlja = new Color(R, G, B);
		g.setColor(zemlja);

		// fillOval(x,y,r,r) crta od gornjeg levog ugla i prima kao
		// argument precnik a ne poluprecnik
		// x-r/2, y-r/2 potrebno kako bi se centar kruga postavio u centar
		// kvadrata povrsine r*r
		g.fillOval(super.getX() - super.getPrecnik() / 2, super.getY() - super.getPrecnik() / 2, super.getPrecnik(),
				super.getPrecnik());
	}

	@Override
	public void run() {
		// u run metodi postavljam za nove koordinate pomerene koordinate
		// kada se ponovo pozove draw metoda, nebeski objekat se iscrtava tamo
		// gde treba da bude
		while (true) {
			setX((int) (obj[0].getX() + super.getRastojanje() * Math.cos(PlaneteCanvas.alpha)));
			setY((int) (obj[0].getY() + super.getRastojanje() * Math.sin(PlaneteCanvas.alpha)));
		}
	}

}
